IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Banelco_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Banelco_TX
END
GO

CREATE FUNCTION [dbo].[CF_Banelco_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT) 
RETURNS CHAR(280)
AS
BEGIN

DECLARE @Retorno			CHAR(280)
DECLARE @aCod_Registro		CHAR(1)		/*Cdigo de Registro. Valor fijo: 5. Indica que este rengln forma parte del detalle.*/
DECLARE @aId_Cliente		CHAR(19)	/*Identificacin del cliente en la empresa.  Se refiere a la identificacin que deber ingresar el cliente para poder pagar, que le sirve a la empresa para saber quien le est pagando. Son los nmeros que componen el concepto utilizado como ID del cliente que la empresa complet en el formulario de adhesin.*/
DECLARE @aId_Trans			CHAR(20)	/*Identificacin de la factura. Se refiere a la identificacin particular de la factura que est pagando el cliente. No tiene que ser obligatoriamente el Nro. de Factura, sino que puede ser cualquier nmero que utilice la empresa para individualizar el pago (puede que para un mismo Nro. Referencia, haya varios Id. Factura, si un cliente tiene varias facturas a pagar).*/
DECLARE @aId_Moneda			CHAR(1)		/*Cdigo de moneda de los importes informados. Valor fijo: 0 (Pesos).*/
DECLARE @aFecha_PriVenc		CHAR(8)		/*Fecha del 1er vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_PriVenc	CHAR(11)	/*Importe de la factura para el 1er vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFecha_SegVenc		CHAR(8)		/*Fecha del 2do vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_SegVenc	CHAR(11)	/*Importe de la factura para el 2do vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFecha_TerVenc		CHAR(8)		/*Fecha del 3er vencimiento de la factura Formato: AAAAMMDD*/
DECLARE @aImporte_TerVenc	CHAR(11)	/*Importe de la factura para el 3er vencimiento. Formato: 9 enteros, 2 decimales, sin separadores*/
DECLARE @aFiller1			CHAR(19)	/*Campo para uso futuro. Valor fijo: ceros.*/
DECLARE @aId_Cliente_Externo CHAR(19)	/*Se debe repetir la informacin del campo Nro. Referencia. En caso que se modifique la identificacin del cliente, se deber informar la identificacin anterior por nica vez, luego se deber repetir la informacin del campo Nro. Referencia.*/
DECLARE @aMensajeTicket		CHAR(40)	/*Datos a informar en el ticket de pago. Es el mensaje  que se imprimir en el comprobante de pago que se refiere al concepto abonado por el cliente. Ej: Cuota Noviembre.*/
DECLARE @aMensajePantalla	CHAR(15)	/*Datos a informar en la pantalla de seleccin de la factura a pagar. Es el mensaje que ver el cliente en pantalla antes de confirmar el pago. Se refiere al mismo concepto que el campo Mensaje Ticket, pero con menos caracteres.*/
DECLARE @aCodBarra			CHAR(60)	/*Cdigo de barras. Son los nmeros que componen el cdigo de barras de la empresa. Si no posee uno, se debe completar el campo con espacios.*/
DECLARE @aFiller2			CHAR(29)	/*Campo para uso futuro. Valor fijo: ceros.*/
DECLARE @Id_Cliente			INT
DECLARE @Fecha				DATETIME
DECLARE @CantCerosCompletarId_Cliente INT
DECLARE @Fecha_Presentacion		DATETIME
DECLARE @Id_Cond_Pago		SMALLINT
DECLARE @Cant_Dias_Desde_Cbtes_Hasta_Presentacion INT
DECLARE @Porc_Recargo		DECIMAL(12,5)	
DECLARE @Fecha_PriVenc		DATETIME
DECLARE @Fecha_SegVenc		DATETIME
DECLARE @Fecha_TerVenc		DATETIME

/*Seteo Variables Locales*/
SELECT	@Fecha_Presentacion = ISNULL(Fecha_Presentacion, '19000101')
FROM Val_Tarjetas_Lotes
WHERE
Id_Tar_Lote = @pId_Tar_Lote


SELECT	@Id_Cliente		= Id_Cliente,
		@Fecha			= Fecha,
		@Id_Cond_Pago	= Id_Cond_Pago
FROM Cbtes 
WHERE
Id_Trans = @pId_Trans


SET @Porc_Recargo = ISNULL((SELECT Porc_Bonif FROM Cbtes_Cond_Pago_Items WHERE Id_Cond_Pago = @Id_Cond_Pago AND Plazo_Desde <= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion AND Plazo_Bonif >= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion),0)

IF(@Porc_Recargo = 0)
BEGIN
	SET @Porc_Recargo = 1
END
ELSE
BEGIN
	SET @Porc_Recargo = (@Porc_Recargo / 100) + 1
END

SET @CantCerosCompletarId_Cliente = dbo.CF_xParam('Banelco_CantDigCli')

/*Seteo variables del Archivo*/
SET @aCod_Registro		= '5'

IF(@CantCerosCompletarId_Cliente = 0)
BEGIN
	SET @aId_Cliente		= (CAST(@Id_Cliente AS VARCHAR))
END

IF(@CantCerosCompletarId_Cliente = 8)
BEGIN
	SET @aId_Cliente		= (RIGHT('00000000' + CAST(@Id_Cliente AS VARCHAR), 8))
END

SET @aId_Trans			= (SELECT RIGHT( '000000000000000' + CAST(@pId_Trans AS VARCHAR), 15))
                 
SET @aId_Moneda			= '0'

SET @Fecha_PriVenc		=  dbo.CF_FOMONTH(@Fecha_Presentacion)
SET @Fecha_PriVenc		= DATEADD(dd, 14, @Fecha_PriVenc)

SET @aFecha_PriVenc = (	SELECT 
							CAST(DATEPART(YY, @Fecha_PriVenc) AS CHAR(4)) + 
							RIGHT('00' + CAST(DATEPART(mm, @Fecha_PriVenc) AS VARCHAR),2) + 
							RIGHT('00' + CAST(DATEPART(dd, @Fecha_PriVenc) AS VARCHAR),2))

/*Calculo Porcentaje segun cond Pago*/
SET @Cant_Dias_Desde_Cbtes_Hasta_Presentacion = DATEDIFF(dd, @Fecha, @Fecha_PriVenc) + 1
SET @Porc_Recargo = ISNULL((SELECT Porc_Bonif FROM Cbtes_Cond_Pago_Items WHERE Id_Cond_Pago = @Id_Cond_Pago AND Plazo_Desde <= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion AND Plazo_Bonif >= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion),0)

IF(@Porc_Recargo = 0)
BEGIN
	SET @Porc_Recargo = 1
END
ELSE
BEGIN
	SET @Porc_Recargo = (@Porc_Recargo / 100) + 1
END
/*FIN Calculo Porcentaje segun cond Pago*/

SET @aImporte_PriVenc	= (SELECT RIGHT('00000000000' + CAST(CAST(@pImporte * @Porc_Recargo * 100 AS INT) AS VARCHAR), 11))


SET @Fecha_SegVenc		= DATEADD(dd, 1, @Fecha_PriVenc)

SET @aFecha_SegVenc		= (	SELECT 
							CAST(DATEPART(YY, @Fecha_SegVenc) AS CHAR(4)) + 
							RIGHT('00' + CAST(DATEPART(mm, @Fecha_SegVenc) AS VARCHAR),2) + 
							RIGHT('00' + CAST(DATEPART(dd, @Fecha_SegVenc) AS VARCHAR),2))

/*Calculo Porcentaje segun cond Pago*/
SET @Cant_Dias_Desde_Cbtes_Hasta_Presentacion = DATEDIFF(dd, @Fecha, @Fecha_SegVenc) + 1
SET @Porc_Recargo = ISNULL((SELECT Porc_Bonif FROM Cbtes_Cond_Pago_Items WHERE Id_Cond_Pago = @Id_Cond_Pago AND Plazo_Desde <= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion AND Plazo_Bonif >= @Cant_Dias_Desde_Cbtes_Hasta_Presentacion),0)

IF(@Porc_Recargo = 0)
BEGIN
	SET @Porc_Recargo = 1
END
ELSE
BEGIN
	SET @Porc_Recargo = (@Porc_Recargo / 100) + 1
END
/*FIN Calculo Porcentaje segun cond Pago*/

SET @aImporte_SegVenc	= (SELECT RIGHT('00000000000' + CAST(CAST(@pImporte * @Porc_Recargo * 100 AS INT) AS VARCHAR), 11))

SET @aFecha_TerVenc		= '00000000'

SET @aImporte_TerVenc	= '00000000000'

SET @aFiller1			= '0000000000000000000'

/*20/05/2019. Se Cambia el Campo Id_Cliente_Externo por Id_Cliente por el ticket 16.648 ya que se indica que el Identificador de Cliente (Campo 2) debe ser igual al Campo 12*/
--SET @aId_Cliente_Externo = (SELECT CAST(ISNULL(Id_Cliente_Externo, '') AS VARCHAR) FROM Clientes WHERE Id_Cliente = @Id_Cliente)
IF(@CantCerosCompletarId_Cliente = 0)
BEGIN
	SET @aId_Cliente_Externo = (CAST(@Id_Cliente AS VARCHAR))
END

IF(@CantCerosCompletarId_Cliente = 8)
BEGIN
	SET @aId_Cliente_Externo = (RIGHT('00000000' + CAST(@Id_Cliente AS VARCHAR), 8))
END
		 
SET @aMensajeTicket		= 'MES' + RIGHT('00' + CAST(MONTH(@Fecha) AS VARCHAR), 2) + '/' + CAST(YEAR(@Fecha) AS CHAR(4)) + '                              '
SET @aMensajePantalla	= 'MES' + RIGHT('00' + CAST(MONTH(@Fecha) AS VARCHAR), 2) + '/' + CAST(YEAR(@Fecha) AS CHAR(4)) + '     '
                
SET @aCodBarra = (dbo.CF_Banelco_CB_TX(@pId_Trans, @pImporte)) 

SET @aFiller2			= '00000000000000000000000000000'
                    
SET @Retorno =	@aCod_Registro		+ 
				@aId_Cliente		+ 
				@aId_Trans			+ 
				@aId_Moneda			+
				@aFecha_PriVenc		+
				@aImporte_PriVenc	+
				@aFecha_SegVenc		+
				@aImporte_SegVenc	+
				@aFecha_TerVenc		+
				@aImporte_TerVenc	+
				@aFiller1			+
				@aId_Cliente_Externo +
				@aMensajeTicket		+
				@aMensajePantalla	+
				@aCodBarra			+
				@aFiller2
   
RETURN ISNULL(@Retorno, '                                                                                                                                                                                                                                                                                        ')
END
